define("core/local/process_monitor/manager",["exports","core/reactive","core/local/process_monitor/events"],(function(_exports,_reactive,_events){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.manager=void 0;
/**
   * The reactive file uploader class.
   *
   * As all the upload queues are reactive, any plugin can implement its own upload monitor.
   *
   * @module     core/local/process_monitor/manager
   * @class      ProcessMonitorManager
   * @copyright  2021 Ferran Recio <ferran@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
class ProcessMonitorManager extends _reactive.Reactive{constructor(){var obj,key,value;super(...arguments),value=1,(key="nextId")in(obj=this)?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value}generateProcessId(){return this.nextId++}}const mutations={addProcess:function(stateManager,processData){const state=stateManager.state;stateManager.setReadOnly(!1),state.queue.add({...processData}),state.display.show=!0,stateManager.setReadOnly(!0)},removeProcess:function(stateManager,processId){const state=stateManager.state;stateManager.setReadOnly(!1),state.queue.delete(processId),0===state.queue.size&&(state.display.show=!1),stateManager.setReadOnly(!0)},updateProcess:function(stateManager,processData){if(void 0===processData.id)throw Error("Missing process ID in process data");const state=stateManager.state;stateManager.setReadOnly(!1);const queueItem=state.queue.get(processData.id);if(!queueItem)throw Error("Unkown process with id ".concat(processData.id));for(const[prop,propValue]of Object.entries(processData))queueItem[prop]=propValue;stateManager.setReadOnly(!0)},setShow:function(stateManager,show){const state=stateManager.state;stateManager.setReadOnly(!1),state.display.show=show,show||this.cleanFinishedProcesses(stateManager),stateManager.setReadOnly(!0)},removeAllProcesses:function(stateManager){const state=stateManager.state;stateManager.setReadOnly(!1),state.queue.forEach((element=>{state.queue.delete(element.id)})),state.display.show=!1,stateManager.setReadOnly(!0)},cleanFinishedProcesses:function(stateManager){const state=stateManager.state;stateManager.setReadOnly(!1),state.queue.forEach((element=>{element.finished&&!element.error&&state.queue.delete(element.id)})),0===state.queue.size&&(state.display.show=!1),stateManager.setReadOnly(!0)}},manager=new ProcessMonitorManager({name:"ProcessMonitor",eventName:_events.eventTypes.processMonitorStateChange,eventDispatch:_events.dispatchStateChangedEvent,mutations:mutations,state:{display:{show:!1},queue:[]}});_exports.manager=manager}));

//# sourceMappingURL=manager.min.js.map