/**
 * Autocomplete wrapper for select2 library.
 *
 * @module     core/form-autocomplete
 * @copyright  2015 Damyon Wiese <damyon@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.0
 */
define("core/form-autocomplete",["jquery","core/log","core/str","core/templates","core/notification","core/loadingicon","core/aria","core_form/changechecker"],(function($,log,str,templates,notification,LoadingIcon,Aria,FormChangeChecker){var KEYS_DOWN=40,KEYS_ENTER=13,KEYS_SPACE=32,KEYS_ESCAPE=27,KEYS_COMMA=44,KEYS_UP=38,KEYS_LEFT=37,KEYS_RIGHT=39,uniqueId=Date.now(),activateSelection=function(index,state){var selectionElement=$(document.getElementById(state.selectionId));index=wrapListIndex(index,selectionElement.children("[aria-selected=true]").length);var element=$(selectionElement.children("[aria-selected=true]").get(index)),itemId=state.selectionId+"-"+index;return selectionElement.children().attr("data-active-selection",null).attr("id",""),element.attr("data-active-selection",!0).attr("id",itemId),selectionElement.attr("aria-activedescendant",itemId),selectionElement.attr("data-active-value",element.attr("data-value")),$.Deferred().resolve()},updateActiveSelectionFromState=function(state){var activeElement=function(state){var _selectionRegion$attr,selectionRegion=$(document.getElementById(state.selectionId)),activeId=selectionRegion.attr("aria-activedescendant");if(activeId){var activeElement=$(document.getElementById(activeId));if(activeElement.length)return activeElement}var activeValue=null===(_selectionRegion$attr=selectionRegion.attr("data-active-value"))||void 0===_selectionRegion$attr?void 0:_selectionRegion$attr.replace(/"/g,'\\"');return selectionRegion.find('[data-value="'+activeValue+'"]')}(state),activeValue=activeElement.attr("data-value"),selectionRegion=$(document.getElementById(state.selectionId));if(activeValue){var activeIndex=selectionRegion.find("[aria-selected=true]").index(activeElement);if(-1!==activeIndex)return void activateSelection(activeIndex,state)}activateSelection(0,state)},updateSelectionList=function(options,state,originalSelect){var pendingKey="form-autocomplete-updateSelectionList-"+state.inputId;M.util.js_pending(pendingKey);var items=rebuildOptions(originalSelect.children("option:selected"),!1),newSelection=$(document.getElementById(state.selectionId));if(!hasItemListChanged(state,items))return M.util.js_complete(pendingKey),Promise.resolve();state.items=items;var context=$.extend(options,state);return templates.render(options.templates.items,context).then((function(html,js){templates.replaceNodeContents(newSelection,html,js),updateActiveSelectionFromState(state)})).then((function(){return M.util.js_complete(pendingKey)})).catch(notification.exception)},hasItemListChanged=function(state,items){return state.items.length!==items.length||state.items.filter((item=>-1===items.indexOf(item))).length>0},notifyChange=function(originalSelect){FormChangeChecker.markFormChangedFromNode(originalSelect[0]),originalSelect[0].dispatchEvent(new Event("change"))},deselectItem=function(options,state,item,originalSelect){var selectedItemValue=$(item).attr("data-value");return originalSelect.prepend($("<option>")),originalSelect.children("option").each((function(index,ele){$(ele).attr("value")==selectedItemValue&&($(ele).prop("selected",!1),$(ele).attr("data-iscustom")&&$(ele).remove())})),updateSelectionList(options,state,originalSelect).then((function(){notifyChange(originalSelect)}))},activateItem=function(index,state){var inputElement=$(document.getElementById(state.inputId)),suggestionsElement=$(document.getElementById(state.suggestionsId)),length=suggestionsElement.children(":not([aria-hidden])").length;for(index%=length;index<0;)index+=length;var element=$(suggestionsElement.children(":not([aria-hidden])").get(index)),globalIndex=$(suggestionsElement.children("[role=option]")).index(element),itemId=state.suggestionsId+"-"+globalIndex;suggestionsElement.children().attr("aria-selected",!1).attr("id",""),element.attr("aria-selected",!0).attr("id",itemId),inputElement.attr("aria-activedescendant",itemId);var scrollPos=element.offset().top-suggestionsElement.offset().top+suggestionsElement.scrollTop()-suggestionsElement.height()/2;return suggestionsElement.animate({scrollTop:scrollPos},100).promise()},getCurrentItem=function(suggestionsElement){var element=suggestionsElement.children("[aria-selected=true]");return suggestionsElement.children(":not([aria-hidden])").index(element)},wrapListIndex=function(index,length){for(index%=length;index<0;)index+=length;return index},getNextEnabledItem=function(current,suggestions){var nextIndex=wrapListIndex(current+1,suggestions.length);return suggestions[nextIndex].getAttribute("aria-disabled")?getNextEnabledItem(nextIndex,suggestions):nextIndex},getPreviousEnabledItem=function(current,suggestions){var previousIndex=wrapListIndex(current-1,suggestions.length);return suggestions[previousIndex].getAttribute("aria-disabled")?getPreviousEnabledItem(previousIndex,suggestions):previousIndex},rebuildOptions=function(originalOptions,includeEmpty){var options=[];return originalOptions.each((function(index,ele){var label;label=$(ele).data("html")?$(ele).data("html"):$(ele).html(),(includeEmpty||""!==label)&&options.push({label:label,value:$(ele).attr("value"),disabled:ele.disabled})})),options},closeSuggestions=function(state){var inputElement=$(document.getElementById(state.inputId)),suggestionsElement=$(document.getElementById(state.suggestionsId));return"true"===inputElement.attr("aria-expanded")&&inputElement.attr("aria-expanded",!1),inputElement.attr("aria-activedescendant",state.selectionId),Aria.hide(suggestionsElement.get()),suggestionsElement.hide(),$.Deferred().resolve()},updateSuggestions=function(options,state,query,originalSelect){var pendingKey="form-autocomplete-updateSuggestions-"+state.inputId;M.util.js_pending(pendingKey);var inputElement=$(document.getElementById(state.inputId)),suggestionsElement=$(document.getElementById(state.suggestionsId)),matchingElements=!1,suggestions=rebuildOptions(originalSelect.children("option:not(:selected)"),!0),searchquery=state.caseSensitive?query:query.toLocaleLowerCase(),context=$.extend({options:suggestions},options,state);return templates.render("core/form_autocomplete_suggestions",context).then((function(html,js){return templates.replaceNode(suggestionsElement,html,js),suggestionsElement=$(document.getElementById(state.suggestionsId)),Aria.unhide(suggestionsElement.get()),suggestionsElement.show(),suggestionsElement.children().each((function(index,node){node=$(node),options.caseSensitive&&node.text().indexOf(searchquery)>-1||!options.caseSensitive&&node.text().toLocaleLowerCase().indexOf(searchquery)>-1?(Aria.unhide(node.get()),node.show(),matchingElements=!0):(node.hide(),Aria.hide(node.get()))})),inputElement.attr("aria-expanded",!0),originalSelect.attr("data-notice")?suggestionsElement.html(originalSelect.attr("data-notice")):matchingElements?options.tags||activateItem(0,state):str.get_string("nosuggestions","form").done((function(nosuggestionsstr){suggestionsElement.html(nosuggestionsstr)})),suggestionsElement})).then((function(){return M.util.js_complete(pendingKey)})).catch(notification.exception)},createItem=function(options,state,originalSelect){var inputElement=$(document.getElementById(state.inputId)),tags=inputElement.val().split(","),found=!1;return $.each(tags,(function(tagindex,tag){if(""!==(tag=tag.trim())&&(options.multiple||originalSelect.children("option").prop("selected",!1),originalSelect.children("option").each((function(index,ele){$(ele).attr("value")==tag&&(found=!0,$(ele).prop("selected",!0))})),!found)){var option=$("<option>");option.append(document.createTextNode(tag)),option.attr("value",tag),originalSelect.append(option),option.prop("selected",!0),option.attr("data-iscustom",!0)}})),updateSelectionList(options,state,originalSelect).then((function(){notifyChange(originalSelect)})).then((function(){inputElement.val("")})).then((function(){return closeSuggestions(state)}))},selectCurrentItem=function(options,state,originalSelect){var inputElement=$(document.getElementById(state.inputId)),selectedItemValue=$(document.getElementById(state.suggestionsId)).children("[aria-selected=true]").attr("data-value");return options.multiple||originalSelect.children("option").prop("selected",!1),originalSelect.children("option").each((function(index,ele){$(ele).attr("value")==selectedItemValue&&$(ele).prop("selected",!0)})),updateSelectionList(options,state,originalSelect).then((function(){notifyChange(originalSelect)})).then((function(){return options.closeSuggestionsOnSelect?(inputElement.val(""),closeSuggestions(state)):(inputElement.focus(),updateSuggestions(options,state,inputElement.val(),originalSelect))}))},updateAjax=function(e,options,state,originalSelect,ajaxHandler){var pendingPromise=addPendingJSPromise("updateAjax"),parentElement=$(document.getElementById(state.selectId)).parent();LoadingIcon.addIconToContainerRemoveOnCompletion(parentElement,pendingPromise);var query=$(e.currentTarget).val();return ajaxHandler.transport(options.selector,query,(function(results){var processedResults=ajaxHandler.processResults(options.selector,results),existingValues=[];if(originalSelect.children("option").each((function(optionIndex,option){(option=$(option)).prop("selected")?existingValues.push(String(option.attr("value"))):option.remove()})),!options.multiple&&0===originalSelect.children("option").length){var option=$("<option>");originalSelect.append(option)}$.isArray(processedResults)?($.each(processedResults,(function(resultIndex,result){if(-1===existingValues.indexOf(String(result.value))){var option=$("<option>");option.append(result.label),option.attr("value",result.value),originalSelect.append(option)}})),originalSelect.attr("data-notice","")):originalSelect.attr("data-notice",processedResults),pendingPromise.resolve(updateSuggestions(options,state,"",originalSelect))}),(function(error){pendingPromise.reject(error)})),pendingPromise},addNavigation=function(options,state,originalSelect){var inputElement=$(document.getElementById(state.inputId));(inputElement.on("keydown",(function(e){var pendingJsPromise=addPendingJSPromise("addNavigation-"+state.inputId+"-"+e.keyCode);switch(e.keyCode){case KEYS_DOWN:return options.showSuggestions?("true"===inputElement.attr("aria-expanded")?pendingJsPromise.resolve(function(state){var suggestionsElement=$(document.getElementById(state.suggestionsId)),suggestions=suggestionsElement.children(":not([aria-hidden])"),current=getCurrentItem(suggestionsElement);return activateItem(getNextEnabledItem(current,suggestions),state)}(state)):!inputElement.val()&&options.ajax?require([options.ajax],(function(ajaxHandler){pendingJsPromise.resolve(updateAjax(e,options,state,originalSelect,ajaxHandler))})):pendingJsPromise.resolve(updateSuggestions(options,state,inputElement.val(),originalSelect)),e.preventDefault(),!1):(pendingJsPromise.resolve(),!0);case KEYS_UP:return pendingJsPromise.resolve(function(state){var suggestionsElement=$(document.getElementById(state.suggestionsId)),suggestions=suggestionsElement.children(":not([aria-hidden])"),current=getCurrentItem(suggestionsElement);return activateItem(getPreviousEnabledItem(current,suggestions),state)}(state)),e.preventDefault(),!1;case KEYS_ENTER:var suggestionsElement=$(document.getElementById(state.suggestionsId));return"true"===inputElement.attr("aria-expanded")&&suggestionsElement.children("[aria-selected=true]").length>0?pendingJsPromise.resolve(selectCurrentItem(options,state,originalSelect)):options.tags?pendingJsPromise.resolve(createItem(options,state,originalSelect)):pendingJsPromise.resolve(),e.preventDefault(),!1;case KEYS_ESCAPE:return"true"===inputElement.attr("aria-expanded")?pendingJsPromise.resolve(closeSuggestions(state)):pendingJsPromise.resolve(),e.preventDefault(),!1}return pendingJsPromise.resolve(),!0})),inputElement.on("keypress",(function(e){return e.keyCode!==KEYS_COMMA||(options.tags&&addPendingJSPromise("keypress-"+e.keyCode).resolve(createItem(options,state,originalSelect)),e.preventDefault(),!1)})),inputElement.closest("form").on("submit",(function(){return options.tags&&addPendingJSPromise("form-autocomplete-submit").resolve(createItem(options,state,originalSelect)),!0})),inputElement.on("blur",(function(){var pendingPromise=addPendingJSPromise("form-autocomplete-blur");window.setTimeout((function(){var focusElement=$(document.activeElement),timeoutPromise=$.Deferred();focusElement.is(document.getElementById(state.suggestionsId))?inputElement.focus():!focusElement.is(inputElement)&&$(document.getElementById(state.inputId)).length&&(options.tags&&timeoutPromise.then((function(){return createItem(options,state,originalSelect)})).catch(),timeoutPromise.then((function(){return closeSuggestions(state)})).catch()),timeoutPromise.then((function(){return pendingPromise.resolve()})).catch(),timeoutPromise.resolve()}),500)})),options.showSuggestions)&&$(document.getElementById(state.downArrowId)).on("click",(function(e){var pendingPromise=addPendingJSPromise("form-autocomplete-show-suggestions");inputElement.focus(),!inputElement.val()&&options.ajax?require([options.ajax],(function(ajaxHandler){pendingPromise.resolve(updateAjax(e,options,state,originalSelect,ajaxHandler))})):pendingPromise.resolve(updateSuggestions(options,state,inputElement.val(),originalSelect))}));var suggestionsElement=$(document.getElementById(state.suggestionsId));suggestionsElement.parent().prop("onclick",null).off("click"),suggestionsElement.parent().on("click","#".concat(state.suggestionsId," [role=option]"),(function(e){var pendingPromise=addPendingJSPromise("form-autocomplete-parent"),element=$(e.currentTarget).closest("[role=option]"),current=$(document.getElementById(state.suggestionsId)).children(":not([aria-hidden])").index(element);activateItem(current,state).then((function(){return selectCurrentItem(options,state,originalSelect)})).then((function(){return pendingPromise.resolve()})).catch()}));var selectionElement=$(document.getElementById(state.selectionId));selectionElement.on("click","[role=option]",(function(e){addPendingJSPromise("form-autocomplete-clicks").resolve(deselectItem(options,state,$(e.currentTarget),originalSelect))})),selectionElement.on("focus",(function(){updateActiveSelectionFromState(state)})),selectionElement.on("keydown",(function(e){var pendingPromise=addPendingJSPromise("form-autocomplete-keydown-"+e.keyCode);switch(e.keyCode){case KEYS_RIGHT:case KEYS_DOWN:return e.preventDefault(),void pendingPromise.resolve(function(state){var selectionsElement=$(document.getElementById(state.selectionId)),element=selectionsElement.children("[data-active-selection]"),current=0;return element?(current=selectionsElement.children("[aria-selected=true]").index(element),current+=1):current=0,activateSelection(current,state)}(state));case KEYS_LEFT:case KEYS_UP:return e.preventDefault(),void pendingPromise.resolve(function(state){var selectionsElement=$(document.getElementById(state.selectionId)),element=selectionsElement.children("[data-active-selection]");if(!element)return activateSelection(0,state);var current=selectionsElement.children("[aria-selected=true]").index(element);return activateSelection(current-1,state)}(state));case KEYS_SPACE:case KEYS_ENTER:var selectedItem=$(document.getElementById(state.selectionId)).children("[data-active-selection]");return void(selectedItem&&(e.preventDefault(),pendingPromise.resolve(deselectItem(options,state,selectedItem,originalSelect))))}pendingPromise.resolve()})),options.showSuggestions&&(inputElement.on("focus",(function(e){var query=$(e.currentTarget).val();$(e.currentTarget).data("last-value",query)})),options.ajax?require([options.ajax],(function(ajaxHandler){var throttleTimeout=null,inProgress=!1,pendingKey="autocomplete-throttledhandler",handler=function(e){throttleTimeout=null,inProgress=!0,updateAjax(e,options,state,originalSelect,ajaxHandler).then((function(){return null===throttleTimeout&&M.util.js_complete(pendingKey),inProgress=!1,arguments[0]})).catch(notification.exception)},throttledHandler=function(e){window.clearTimeout(throttleTimeout),inProgress?throttleTimeout=window.setTimeout(throttledHandler.bind(this,e),100):(null===throttleTimeout&&M.util.js_pending(pendingKey),throttleTimeout=window.setTimeout(handler.bind(this,e),300))};inputElement.on("input",(function(e){var query=$(e.currentTarget).val();$(e.currentTarget).data("last-value")!==query&&throttledHandler(e),$(e.currentTarget).data("last-value",query)}))})):inputElement.on("input",(function(e){var query=$(e.currentTarget).val();$(e.currentTarget).data("last-value")!==query&&updateSuggestions(options,state,query,originalSelect),$(e.currentTarget).data("last-value",query)})))},addPendingJSPromise=function(key){var pendingKey="form-autocomplete:"+key;M.util.js_pending(pendingKey);var pendingPromise=$.Deferred();return pendingPromise.then((function(){return M.util.js_complete(pendingKey),arguments[0]})).catch(notification.exception),pendingPromise};return{enhance:function(selector,tags,ajax,placeholder,caseSensitive,showSuggestions,noSelectionString,closeSuggestionsOnSelect,templateOverrides){var options={selector:selector,tags:!1,ajax:!1,placeholder:placeholder,caseSensitive:!1,showSuggestions:!0,noSelectionString:noSelectionString,templates:$.extend({input:"core/form_autocomplete_input",items:"core/form_autocomplete_selection_items",layout:"core/form_autocomplete_layout",selection:"core/form_autocomplete_selection",suggestions:"core/form_autocomplete_suggestions"},templateOverrides)},pendingKey="autocomplete-setup-"+selector;M.util.js_pending(pendingKey),void 0!==tags&&(options.tags=tags),void 0!==ajax&&(options.ajax=ajax),void 0!==caseSensitive&&(options.caseSensitive=caseSensitive),void 0!==showSuggestions&&(options.showSuggestions=showSuggestions),void 0===noSelectionString&&str.get_string("noselection","form").done((function(result){options.noSelectionString=result})).fail(notification.exception);var originalSelect=$(selector);if(!originalSelect)return log.debug("Selector not found: "+selector),M.util.js_complete(pendingKey),!1;if("enhanced"===originalSelect.data("enhanced"))return M.util.js_complete(pendingKey),!1;originalSelect.data("enhanced","enhanced"),Aria.hide(originalSelect.get()),originalSelect.css("visibility","hidden");var state={selectId:originalSelect.attr("id"),inputId:"form_autocomplete_input-"+uniqueId,suggestionsId:"form_autocomplete_suggestions-"+uniqueId,selectionId:"form_autocomplete_selection-"+uniqueId,downArrowId:"form_autocomplete_downarrow-"+uniqueId,items:[]};uniqueId++,options.multiple=originalSelect.attr("multiple"),options.multiple||originalSelect.prepend("<option>"),options.closeSuggestionsOnSelect=void 0!==closeSuggestionsOnSelect?closeSuggestionsOnSelect:!options.multiple;var originalLabel=$("[for="+state.selectId+"]"),suggestions=rebuildOptions(originalSelect.children("option"),!0),context=$.extend({},options,state);context.options=suggestions,context.items=[];var collectedjs="",renderLayout=templates.render(options.templates.layout,{}).then((function(html){return $(html)})),renderInput=templates.render(options.templates.input,context).then((function(html,js){return collectedjs+=js,$(html)})),renderDatalist=templates.render(options.templates.suggestions,context).then((function(html,js){return collectedjs+=js,$(html)})),renderSelection=templates.render(options.templates.selection,context).then((function(html,js){return collectedjs+=js,$(html)}));return $.when(renderLayout,renderInput,renderDatalist,renderSelection).then((function(layout,input,suggestions,selection){originalSelect.hide();var container=originalSelect.parent();input.find("input").attr("data-fieldtype","autocomplete"),container.append(layout),container.find('[data-region="form_autocomplete-input"]').replaceWith(input),container.find('[data-region="form_autocomplete-suggestions"]').replaceWith(suggestions),container.find('[data-region="form_autocomplete-selection"]').replaceWith(selection),templates.runTemplateJS(collectedjs),originalLabel.attr("for",state.inputId),addNavigation(options,state,originalSelect);var suggestionsElement=$(document.getElementById(state.suggestionsId));suggestionsElement.hide(),Aria.hide(suggestionsElement.get())})).then((function(){return updateSelectionList(options,state,originalSelect)})).then((function(){return M.util.js_complete(pendingKey)})).catch((function(error){M.util.js_complete(pendingKey),notification.exception(error)}))}}}));

//# sourceMappingURL=form-autocomplete.min.js.map