define("tiny_media/image",["exports","core/templates","core/str","core/pending","editor_tiny/utils","./selectors","./imagemodal","./options","./common"],(function(_exports,_templates,_str,_pending,_utils,_selectors,_imagemodal,_options,_common){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_templates=_interopRequireDefault(_templates),_pending=_interopRequireDefault(_pending),_selectors=_interopRequireDefault(_selectors),_imagemodal=_interopRequireDefault(_imagemodal);return _exports.default=class{constructor(editor){_defineProperty(this,"DEFAULTS",{WIDTH:160,HEIGHT:160}),_defineProperty(this,"form",null),_defineProperty(this,"rawImageDimensions",null),_defineProperty(this,"canShowFilePicker",!1),_defineProperty(this,"editor",null),_defineProperty(this,"currentModal",null),_defineProperty(this,"selectedImage",null),_defineProperty(this,"imageAlignment",null);const permissions=(0,_options.getImagePermissions)(editor);this.canShowFilePicker=permissions.filepicker,this.editor=editor}async displayDialogue(){this.rawImageDimensions=null;const currentImageData=await this.getCurrentImageData();this.currentModal=await _imagemodal.default.create({title:(0,_str.getString)("imageproperties","tiny_media"),templateContext:await this.getTemplateContext(currentImageData)}),currentImageData&&currentImageData.src&&this.loadPreviewImage(currentImageData.src),await this.registerEventListeners()}async getAlignmentTitles(){if(!this.alignmentTitles){const[top,middle,bottom]=await(0,_str.getStrings)(["alignment_top","alignment_middle","alignment_bottom"].map((key=>({key:key,component:_common.component}))));this.alignmentTitles={top:top,middle:middle,bottom:bottom}}return this.alignmentTitles}async getImageAlignment(){let selected=arguments.length>0&&void 0!==arguments[0]?arguments[0]:"";const titles=await this.getAlignmentTitles(),alignments=[{text:titles.top,value:"align-top"},{text:titles.middle,value:"align-middle"},{text:titles.bottom,value:"align-bottom"}];return selected&&alignments.forEach(((alignment,index,array)=>{alignment.value===selected&&(array[index].selected=!0)})),alignments}async getTemplateContext(data){return{elementid:this.editor.id,showfilepicker:this.canShowFilePicker,alignoptions:await this.getImageAlignment(),...data}}async getCurrentImageData(){const selectedImageProperties=this.getSelectedImageProperties();if(!selectedImageProperties)return{};const properties={...selectedImageProperties};return properties.align&&(properties.alignoptions=await this.getImageAlignment(properties.align)),properties.src&&(properties.haspreview=!0),properties.alt||(properties.presentation=!0),properties}filePickerCallback(params,self){if(params.url){self.form.querySelector(_selectors.default.IMAGE.elements.url).value=params.url,self.form.querySelector(_selectors.default.IMAGE.elements.width).value="",self.form.querySelector(_selectors.default.IMAGE.elements.height).value="",self.loadPreviewImage(params.url)}}storeImageDimensions(image){this.rawImageDimensions={width:image.width||this.DEFAULTS.WIDTH,height:image.height||this.DEFAULTS.HEIGHT};const currentWidth=(element=>(""===element.value&&(element.value=this.rawImageDimensions.width),element.value))(this.form.querySelector(_selectors.default.IMAGE.elements.width)),currentHeight=(element=>(""===element.value&&(element.value=this.rawImageDimensions.height),element.value))(this.form.querySelector(_selectors.default.IMAGE.elements.height)),preview=this.form.querySelector(_selectors.default.IMAGE.elements.preview);preview.setAttribute("src",image.src),preview.style.display="inline";const constrain=this.form.querySelector(_selectors.default.IMAGE.elements.constrain);if(this.isPercentageValue(currentWidth)&&this.isPercentageValue(currentHeight))constrain.checked=currentWidth===currentHeight;else if(0===image.width||0===image.height)constrain.disabled="disabled";else{const widthRatio=Math.round(1e3*parseInt(currentWidth,10)/image.width),heightRatio=Math.round(1e3*parseInt(currentHeight,10)/image.height);constrain.checked=widthRatio===heightRatio}}loadPreviewImage(url){const image=new Image;image.addEventListener("error",(()=>{this.form.querySelector(_selectors.default.IMAGE.elements.preview).style.display="none"})),image.addEventListener("load",(()=>{this.storeImageDimensions(image),this.autoAdjustSize()})),image.src=url}urlChanged(){const input=this.form.querySelector(_selectors.default.IMAGE.elements.url);input.value&&this.loadPreviewImage(input.value)}hasErrorUrlField(){const urlError=""===this.form.querySelector(_selectors.default.IMAGE.elements.url).value;return this.toggleVisibility(_selectors.default.IMAGE.elements.urlWarning,urlError),this.toggleAriaInvalid([_selectors.default.IMAGE.elements.url],urlError),urlError}hasErrorAltField(){const alt=this.form.querySelector(_selectors.default.IMAGE.elements.alt).value,presentation=this.form.querySelector(_selectors.default.IMAGE.elements.presentation).checked,imageAltError=""===alt&&!presentation;return this.toggleVisibility(_selectors.default.IMAGE.elements.altWarning,imageAltError),this.toggleAriaInvalid([_selectors.default.IMAGE.elements.alt,_selectors.default.IMAGE.elements.presentation],imageAltError),imageAltError}toggleVisibility(selector,predicate){this.form.querySelectorAll(selector).forEach((element=>{element.style.display=predicate?"block":"none"}))}toggleAriaInvalid(selectors,predicate){selectors.forEach((selector=>{this.form.querySelectorAll(selector).forEach((element=>element.setAttribute("aria-invalid",predicate)))}))}getAlignmentClass(alignment){return alignment}updateWarning(){const urlError=this.hasErrorUrlField(),imageAltError=this.hasErrorAltField();return urlError||imageAltError}getImageContext(){if(this.updateWarning())return null;const classList=[];this.form.querySelector(_selectors.default.IMAGE.elements.constrain).value&&classList.push(_selectors.default.IMAGE.styles.responsive);const alignment=this.getAlignmentClass(this.form.querySelector(_selectors.default.IMAGE.elements.alignment).value);return classList.push(alignment),{url:this.form.querySelector(_selectors.default.IMAGE.elements.url).value,alt:this.form.querySelector(_selectors.default.IMAGE.elements.alt).value,width:this.form.querySelector(_selectors.default.IMAGE.elements.width).value,height:this.form.querySelector(_selectors.default.IMAGE.elements.height).value,presentation:this.form.querySelector(_selectors.default.IMAGE.elements.presentation).checked,customStyle:this.form.querySelector(_selectors.default.IMAGE.elements.customStyle).value,classlist:classList.join(" ")}}setImage(){const pendingPromise=new _pending.default("tiny_media:setImage");if(""===this.form.querySelector(_selectors.default.IMAGE.elements.url).value)return;if(this.updateWarning())return void pendingPromise.resolve();const width=this.form.querySelector(_selectors.default.IMAGE.elements.width).value;if(!this.isPercentageValue(width)&&isNaN(parseInt(width,10)))return this.form.querySelector(_selectors.default.IMAGE.elements.width).focus(),void pendingPromise.resolve();const height=this.form.querySelector(_selectors.default.IMAGE.elements.height).value;if(!this.isPercentageValue(height)&&isNaN(parseInt(height,10)))return this.form.querySelector(_selectors.default.IMAGE.elements.height).focus(),void pendingPromise.resolve();_templates.default.render("tiny_media/image",this.getImageContext()).then((html=>(this.editor.insertContent(html),this.currentModal.destroy(),pendingPromise.resolve(),html))).catch()}handleKeyupCharacterCount(){const alt=this.form.querySelector(_selectors.default.IMAGE.elements.alt).value;this.form.querySelector("#currentcount").innerHTML=alt.length}autoAdjustSize(){let forceHeight=arguments.length>0&&void 0!==arguments[0]&&arguments[0];if(!this.rawImageDimensions)return;const widthField=this.form.querySelector(_selectors.default.IMAGE.elements.width),heightField=this.form.querySelector(_selectors.default.IMAGE.elements.height),normalizeFieldData=fieldData=>(fieldData.isPercentageValue=!!this.isPercentageValue(fieldData.field.value),fieldData.isPercentageValue?(fieldData.percentValue=parseInt(fieldData.field.value,10),fieldData.pixelSize=this.rawImageDimensions[fieldData.type]/100*fieldData.percentValue):(fieldData.pixelSize=parseInt(fieldData.field.value,10),fieldData.percentValue=fieldData.pixelSize/this.rawImageDimensions[fieldData.type]*100),fieldData),imagePreview=this.form.querySelector(_selectors.default.IMAGE.elements.preview);imagePreview.style.width="",imagePreview.style.height="";const constrainField=this.form.querySelector(_selectors.default.IMAGE.elements.constrain),keyField=(()=>{const currentValue=forceHeight?{field:heightField,type:"height"}:{field:widthField,type:"width"};return""===currentValue.field.value&&(currentValue.field.value=this.rawImageDimensions[currentValue.type]),normalizeFieldData(currentValue)})(),relativeField=normalizeFieldData(forceHeight?{field:widthField,type:"width"}:{field:heightField,type:"height"});constrainField.checked&&(keyField.isPercentageValue?(relativeField.field.value=keyField.field.value,relativeField.percentValue=keyField.percentValue):(relativeField.pixelSize=Math.round(keyField.pixelSize/this.rawImageDimensions[keyField.type]*this.rawImageDimensions[relativeField.type]),relativeField.field.value=relativeField.pixelSize)),function(image,keyField,relativeField){let forceHeight=arguments.length>3&&void 0!==arguments[3]&&arguments[3];const getStyleValue=field=>field.isPercentageValue?"".concat(field.percentValue,"%"):"".concat(field.pixelSize,"px");forceHeight?"width"===keyField.type?image.style.width=getStyleValue(keyField):image.style.width=getStyleValue(relativeField):(image.style[keyField.type]=getStyleValue(keyField),image.style[relativeField.type]=getStyleValue(relativeField))}(imagePreview,keyField,relativeField,!!constrainField.checked)}getSelectedImageProperties(){const image=this.getSelectedImage();if(!image)return this.selectedImage=null,null;const properties={src:null,alt:null,width:null,height:null,align:"",presentation:!1};this.removeLegacyAlignment(image),this.selectedImage=image,properties.customStyle=image.style.cssText;const width=(image=>this.isPercentageValue(String(image.width))?image.width:parseInt(image.width,10))(image);0!==width&&(properties.width=width);const height=(image=>this.isPercentageValue(String(image.height))?image.height:parseInt(image.height,10))(image);0!==height&&(properties.height=height);const alignment=this.getAlignmentProperties(image,properties);return alignment&&(properties.align=alignment.value),properties.src=image.getAttribute("src"),properties.alt=image.getAttribute("alt")||"",properties.presentation="presentation"===image.getAttribute("role"),properties}removeLegacyAlignment(imageNode){return imageNode.style.margin?(_selectors.default.IMAGE.alignments.some((alignment=>{if(imageNode.style[alignment.name]!==alignment.value)return!1;const normalisedNode=document.createElement("div");return normalisedNode.style.margin=alignment.margin,imageNode.style.margin===normalisedNode.style.margin&&(imageNode.classList.add(this.getAlignmentClass(alignment.value)),imageNode.style[alignment.name]=null,imageNode.style.margin=null,!0)})),imageNode):imageNode}getAlignmentProperties(image){const currentAlignment=_selectors.default.IMAGE.alignments.find((alignment=>!!image.classList.contains(this.getAlignmentClass(alignment.value))||!!alignment.legacyValues&&alignment.legacyValues.some((legacyValue=>image.classList.contains(legacyValue)))));return currentAlignment||_selectors.default.IMAGE.alignments.find((alignment=>alignment.isDefault))}getSelectedImage(){const imgElm=this.editor.selection.getNode(),figureElm=this.editor.dom.getParent(imgElm,"figure.image");return figureElm?this.editor.dom.select("img",figureElm)[0]:imgElm&&("IMG"!==imgElm.nodeName.toUpperCase()||this.isPlaceholderImage(imgElm))?null:imgElm}isPlaceholderImage(imgElm){return"IMG"===imgElm.nodeName.toUpperCase()&&(imgElm.hasAttribute("data-mce-object")||imgElm.hasAttribute("data-mce-placeholder"))}isPercentageValue(value){return value.match(/\d+%/)}async registerEventListeners(){await this.currentModal.getBody();const root=this.currentModal.getRoot()[0];this.form=root.querySelector(_selectors.default.IMAGE.elements.form),root.addEventListener("click",(e=>{const submitAction=e.target.closest(_selectors.default.IMAGE.actions.submit),imageBrowserAction=e.target.closest(_selectors.default.IMAGE.actions.imageBrowser);submitAction&&(e.preventDefault(),this.setImage()),imageBrowserAction&&this.canShowFilePicker&&(e.preventDefault(),(0,_utils.displayFilepicker)(this.editor,"image").then((params=>{this.filePickerCallback(params,this)})).catch())})),root.addEventListener("change",(e=>{e.target.closest(_selectors.default.IMAGE.elements.url)&&this.hasErrorUrlField();e.target.closest(_selectors.default.IMAGE.elements.presentation)&&this.hasErrorAltField();e.target.closest(_selectors.default.IMAGE.elements.constrain)&&this.autoAdjustSize(!0)})),root.addEventListener("blur",(e=>{if(e.target.nodeType===Node.ELEMENT_NODE){e.target.closest(_selectors.default.IMAGE.elements.url)&&this.urlChanged();e.target.closest(_selectors.default.IMAGE.elements.alt)&&this.hasErrorAltField();e.target.closest(_selectors.default.IMAGE.elements.width)&&this.autoAdjustSize();e.target.closest(_selectors.default.IMAGE.elements.height)&&this.autoAdjustSize(!0)}}),!0),root.addEventListener("keyup",(e=>{e.target.closest(_selectors.default.IMAGE.elements.alt)&&this.handleKeyupCharacterCount()}))}},_exports.default}));

//# sourceMappingURL=image.min.js.map